<?php

require_once __DIR__ . '/includes/auth.php';

if (Auth::check()) {
    redirect('/');
}

$errors = [];
$username = '';
$email = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = trim($_POST['username'] ?? '');
    $email = trim($_POST['email'] ?? '');
    $password = $_POST['password'] ?? '';
    $confirmPassword = $_POST['confirm_password'] ?? '';

    if (empty($username)) {
        $errors[] = '请输入用户名';
    } elseif (strlen($username) < 3 || strlen($username) > 50) {
        $errors[] = '用户名长度需在3-50个字符之间';
    }

    if (empty($email)) {
        $errors[] = '请输入邮箱';
    } elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $errors[] = '请输入有效的邮箱地址';
    }

    if (empty($password)) {
        $errors[] = '请输入密码';
    } elseif (strlen($password) < 6) {
        $errors[] = '密码长度至少6位';
    }

    if ($password !== $confirmPassword) {
        $errors[] = '两次输入的密码不一致';
    }

    if (empty($errors)) {
        $result = Auth::register($username, $email, $password);
        if ($result['success']) {
            redirectWithMessage('/login.php', '注册成功，请登录');
        } else {
            $errors[] = $result['message'];
        }
    }
}
?>
<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>注册 - <?= SITE_NAME ?></title>
    <link rel="stylesheet" href="https://img.penlife.cn/font/OPPO%20Sans%204/result.css">
    <link rel="stylesheet" href="/assets/css/style.css">
</head>
<body class="auth-page">
    <div class="auth-container">
        <div class="auth-card">
            <div class="auth-header">
                <h1><?= SITE_NAME ?></h1>
                <p>创建新账户</p>
            </div>

            <?php if (!empty($errors)): ?>
                <div class="alert alert-error">
                    <ul>
                        <?php foreach ($errors as $error): ?>
                            <li><?= h($error) ?></li>
                        <?php endforeach; ?>
                    </ul>
                </div>
            <?php endif; ?>

            <form method="POST" class="auth-form">
                <div class="form-group">
                    <label for="username">用户名</label>
                    <input type="text" id="username" name="username" value="<?= h($username) ?>" required autofocus>
                </div>

                <div class="form-group">
                    <label for="email">邮箱</label>
                    <input type="email" id="email" name="email" value="<?= h($email) ?>" required>
                </div>

                <div class="form-group">
                    <label for="password">密码</label>
                    <input type="password" id="password" name="password" required>
                </div>

                <div class="form-group">
                    <label for="confirm_password">确认密码</label>
                    <input type="password" id="confirm_password" name="confirm_password" required>
                </div>

                <button type="submit" class="btn btn-primary btn-block">注册</button>
            </form>

            <div class="auth-footer">
                <p>已有账户？ <a href="/login.php">立即登录</a></p>
                <p><a href="/">返回首页</a></p>
            </div>
        </div>
    </div>
</body>
</html>
