<?php

require_once __DIR__ . '/../config/database.php';

class User {
    public static function all(): array {
        return db()->fetchAll(
            'SELECT id, username, email, role, created_at FROM users ORDER BY id ASC'
        );
    }

    public static function find(int $id): ?array {
        return db()->fetch(
            'SELECT id, username, email, role, created_at FROM users WHERE id = :id',
            ['id' => $id]
        );
    }

    public static function findByUsername(string $username): ?array {
        return db()->fetch(
            'SELECT * FROM users WHERE username = :username',
            ['username' => $username]
        );
    }

    public static function findByEmail(string $email): ?array {
        return db()->fetch(
            'SELECT * FROM users WHERE email = :email',
            ['email' => $email]
        );
    }

    public static function create(array $data): int {
        return db()->insert('users', [
            'username' => $data['username'],
            'email' => $data['email'],
            'password' => password_hash($data['password'], PASSWORD_DEFAULT),
            'role' => $data['role'] ?? 'user'
        ]);
    }

    public static function update(int $id, array $data): bool {
        $updateData = [];

        if (isset($data['username'])) {
            $updateData['username'] = $data['username'];
        }
        if (isset($data['email'])) {
            $updateData['email'] = $data['email'];
        }
        if (isset($data['password'])) {
            $updateData['password'] = password_hash($data['password'], PASSWORD_DEFAULT);
        }
        if (isset($data['role'])) {
            $updateData['role'] = $data['role'];
        }

        if (empty($updateData)) {
            return false;
        }

        return db()->update('users', $updateData, 'id = :id', ['id' => $id]) > 0;
    }

    public static function delete(int $id): bool {
        return db()->delete('users', 'id = :id', ['id' => $id]) > 0;
    }

    public static function count(): int {
        $result = db()->fetch('SELECT COUNT(*) as count FROM users');
        return (int) $result['count'];
    }

    public static function getStats(): array {
        $stats = db()->fetch(
            'SELECT 
                COUNT(*) as total,
                SUM(CASE WHEN role = "admin" THEN 1 ELSE 0 END) as admins,
                SUM(CASE WHEN role = "user" THEN 1 ELSE 0 END) as users
            FROM users'
        );

        return $stats;
    }
}
