<?php

require_once __DIR__ . '/includes/auth.php';

if (Auth::check()) {
    redirect('/');
}

$errors = [];
$username = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = trim($_POST['username'] ?? '');
    $password = $_POST['password'] ?? '';

    if (empty($username)) {
        $errors[] = '请输入用户名';
    }
    if (empty($password)) {
        $errors[] = '请输入密码';
    }

    if (empty($errors)) {
        $result = Auth::attempt($username, $password);
        if ($result['success']) {
            redirect('/');
        } else {
            $errors[] = $result['message'];
        }
    }
}

$flash = getFlashMessage();
?>
<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>登录 - <?= SITE_NAME ?></title>
    <link rel="stylesheet" href="https://img.penlife.cn/font/OPPO%20Sans%204/result.css">
    <link rel="stylesheet" href="/assets/css/style.css">
</head>
<body class="auth-page">
    <div class="auth-container">
        <div class="auth-card">
            <div class="auth-header">
                <h1><?= SITE_NAME ?></h1>
                <p>登录您的账户</p>
            </div>

            <?php if ($flash): ?>
                <div class="alert alert-<?= h($flash['type']) ?>">
                    <?= h($flash['text']) ?>
                </div>
            <?php endif; ?>

            <?php if (!empty($errors)): ?>
                <div class="alert alert-error">
                    <ul>
                        <?php foreach ($errors as $error): ?>
                            <li><?= h($error) ?></li>
                        <?php endforeach; ?>
                    </ul>
                </div>
            <?php endif; ?>

            <form method="POST" class="auth-form">
                <div class="form-group">
                    <label for="username">用户名</label>
                    <input type="text" id="username" name="username" value="<?= h($username) ?>" required autofocus>
                </div>

                <div class="form-group">
                    <label for="password">密码</label>
                    <input type="password" id="password" name="password" required>
                </div>

                <button type="submit" class="btn btn-primary btn-block">登录</button>
            </form>

            <div class="auth-footer">
                <p>还没有账户？ <a href="/register.php">立即注册</a></p>
                <p><a href="/">返回首页</a></p>
            </div>
        </div>
    </div>
</body>
</html>
