<?php

define('INSTALL_LOCK_FILE', __DIR__ . '/install.lock');

if (file_exists(INSTALL_LOCK_FILE)) {
    die('系统已安装，如需重新安装请删除 install.lock 文件');
}

$step = $_GET['step'] ?? '1';
$error = '';
$success = false;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $step = $_POST['step'] ?? $step;

    if ($step === '2') {
        $dbHost = trim($_POST['db_host'] ?? 'localhost');
        $dbName = trim($_POST['db_name'] ?? '');
        $dbUser = trim($_POST['db_user'] ?? '');
        $dbPass = $_POST['db_pass'] ?? '';

        if (empty($dbName) || empty($dbUser)) {
            $error = '请填写数据库名称和用户名';
            $step = '1';
        } else {
            try {
                $dsn = "mysql:host={$dbHost};charset=utf8mb4";
                $pdo = new PDO($dsn, $dbUser, $dbPass, [
                    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION
                ]);

                $pdo->exec("CREATE DATABASE IF NOT EXISTS `{$dbName}` DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci");
                $pdo->exec("USE `{$dbName}`");

                $schemaFile = __DIR__ . '/database/schema.sql';
                if (!file_exists($schemaFile)) {
                    throw new Exception('数据库结构文件不存在');
                }

                $schema = file_get_contents($schemaFile);
                $schema = str_replace('`nav_system`', "`{$dbName}`", $schema);

                $pdo->exec("SET FOREIGN_KEY_CHECKS = 0");
                $pdo->exec($schema);
                $pdo->exec("SET FOREIGN_KEY_CHECKS = 1");

                $_SESSION['install'] = [
                    'db_host' => $dbHost,
                    'db_name' => $dbName,
                    'db_user' => $dbUser,
                    'db_pass' => $dbPass
                ];

                $step = '3';
            } catch (PDOException $e) {
                $error = '数据库连接失败: ' . $e->getMessage();
                $step = '1';
            } catch (Exception $e) {
                $error = $e->getMessage();
                $step = '1';
            }
        }
    }

    if ($step === '4') {
        $adminUser = trim($_POST['admin_user'] ?? '');
        $adminPass = $_POST['admin_pass'] ?? '';
        $adminPassConfirm = $_POST['admin_pass_confirm'] ?? '';
        $adminEmail = trim($_POST['admin_email'] ?? '');

        if (empty($adminUser) || empty($adminPass)) {
            $error = '请填写管理员用户名和密码';
            $step = '3';
        } elseif (strlen($adminUser) < 3 || strlen($adminUser) > 50) {
            $error = '用户名长度需在3-50个字符之间';
            $step = '3';
        } elseif (strlen($adminPass) < 6) {
            $error = '密码长度至少6位';
            $step = '3';
        } elseif ($adminPass !== $adminPassConfirm) {
            $error = '两次输入的密码不一致';
            $step = '3';
        } elseif (!filter_var($adminEmail, FILTER_VALIDATE_EMAIL)) {
            $error = '请输入有效的邮箱地址';
            $step = '3';
        } else {
            try {
                $install = $_SESSION['install'] ?? null;
                if (!$install) {
                    throw new Exception('安装信息丢失，请重新开始');
                }

                $dsn = "mysql:host={$install['db_host']};dbname={$install['db_name']};charset=utf8mb4";
                $pdo = new PDO($dsn, $install['db_user'], $install['db_pass'], [
                    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION
                ]);

                $hashedPassword = password_hash($adminPass, PASSWORD_DEFAULT);

                $stmt = $pdo->prepare("UPDATE users SET username = ?, email = ?, password = ? WHERE username = 'admin'");
                $stmt->execute([$adminUser, $adminEmail, $hashedPassword]);

                $configContent = <<<PHP
<?php

define('DB_HOST', '{$install['db_host']}');
define('DB_NAME', '{$install['db_name']}');
define('DB_USER', '{$install['db_user']}');
define('DB_PASS', '{$install['db_pass']}');
define('DB_CHARSET', 'utf8mb4');

define('SITE_NAME', '网址导航');
define('SITE_URL', '');

define('SESSION_NAME', 'nav_session');
define('SESSION_LIFETIME', 86400);

define('FONT_CSS_URL', 'https://img.penlife.cn/font/OPPO%20Sans%204/result.css');

error_reporting(E_ALL);
ini_set('display_errors', 1);

date_default_timezone_set('Asia/Shanghai');
PHP;

                $configFile = __DIR__ . '/config/config.php';
                if (file_put_contents($configFile, $configContent) === false) {
                    throw new Exception('配置文件写入失败，请检查目录权限');
                }

                file_put_contents(INSTALL_LOCK_FILE, date('Y-m-d H:i:s'));

                unset($_SESSION['install']);
                $success = true;
                $step = '5';
            } catch (Exception $e) {
                $error = $e->getMessage();
                $step = '3';
            }
        }
    }
}

function checkRequirement(string $name, bool $condition, string $note = ''): string {
    $status = $condition ? '<span class="status-pass">✓</span>' : '<span class="status-fail">✗</span>';
    $noteHtml = $note ? "<span class=\"note\">{$note}</span>" : '';
    return "<div class=\"check-item\">{$status} <span>{$name}</span>{$noteHtml}</div>";
}

$phpVersion = PHP_VERSION_ID >= 80000;
$pdoExtension = extension_loaded('pdo');
$pdoMysql = extension_loaded('pdo_mysql');
$gdExtension = extension_loaded('gd');
$curlExtension = extension_loaded('curl');
$writeable = is_writable(__DIR__);

session_start();
?>
<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>安装向导 - 网址导航</title>
    <link rel="stylesheet" href="https://img.penlife.cn/font/OPPO%20Sans%204/result.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'OPPO Sans 4.0', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            font-size: 16px;
            line-height: 1.6;
            color: #0f172a;
            background: linear-gradient(135deg, #f0f9ff 0%, #e0f2fe 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 1rem;
        }

        .install-container {
            width: 100%;
            max-width: 560px;
            background: white;
            border-radius: 1rem;
            box-shadow: 0 10px 40px rgba(0, 0, 0, 0.1);
            overflow: hidden;
        }

        .install-header {
            padding: 2rem;
            text-align: center;
            background: linear-gradient(135deg, #3b82f6 0%, #2563eb 100%);
            color: white;
        }

        .install-header h1 {
            font-size: 1.5rem;
            font-weight: 600;
            margin-bottom: 0.5rem;
        }

        .install-header p {
            opacity: 0.9;
            font-size: 0.9375rem;
        }

        .install-body {
            padding: 2rem;
        }

        .steps {
            display: flex;
            justify-content: center;
            gap: 0.5rem;
            margin-bottom: 2rem;
        }

        .step {
            display: flex;
            align-items: center;
            gap: 0.5rem;
            padding: 0.5rem 1rem;
            border-radius: 9999px;
            font-size: 0.875rem;
            font-weight: 500;
            background: #f1f5f9;
            color: #64748b;
        }

        .step.active {
            background: #eff6ff;
            color: #3b82f6;
        }

        .step.completed {
            background: #dcfce7;
            color: #16a34a;
        }

        .step-number {
            width: 1.5rem;
            height: 1.5rem;
            display: flex;
            align-items: center;
            justify-content: center;
            border-radius: 50%;
            background: currentColor;
            color: white;
            font-size: 0.75rem;
        }

        .section-title {
            font-size: 1.125rem;
            font-weight: 600;
            margin-bottom: 1.5rem;
            padding-bottom: 0.75rem;
            border-bottom: 2px solid #e2e8f0;
        }

        .check-list {
            margin-bottom: 1.5rem;
        }

        .check-item {
            display: flex;
            align-items: center;
            gap: 0.75rem;
            padding: 0.75rem;
            border-radius: 0.5rem;
            background: #f8fafc;
            margin-bottom: 0.5rem;
        }

        .status-pass {
            color: #16a34a;
            font-weight: 600;
        }

        .status-fail {
            color: #ef4444;
            font-weight: 600;
        }

        .note {
            margin-left: auto;
            font-size: 0.8125rem;
            color: #64748b;
        }

        .form-group {
            margin-bottom: 1.25rem;
        }

        .form-group label {
            display: block;
            margin-bottom: 0.5rem;
            font-size: 0.875rem;
            font-weight: 500;
        }

        .form-group input {
            width: 100%;
            padding: 0.75rem 1rem;
            font-size: 0.9375rem;
            font-family: inherit;
            border: 1px solid #e2e8f0;
            border-radius: 0.5rem;
            transition: border-color 0.15s, box-shadow 0.15s;
        }

        .form-group input:focus {
            outline: none;
            border-color: #3b82f6;
            box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.15);
        }

        .form-group .hint {
            margin-top: 0.375rem;
            font-size: 0.8125rem;
            color: #64748b;
        }

        .alert {
            padding: 1rem;
            border-radius: 0.5rem;
            margin-bottom: 1.5rem;
            font-size: 0.9375rem;
        }

        .alert-error {
            background: #fee2e2;
            color: #991b1b;
            border: 1px solid #fecaca;
        }

        .alert-success {
            background: #dcfce7;
            color: #166534;
            border: 1px solid #bbf7d0;
        }

        .btn {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            padding: 0.75rem 1.5rem;
            font-size: 0.9375rem;
            font-weight: 500;
            font-family: inherit;
            border-radius: 0.5rem;
            border: none;
            cursor: pointer;
            transition: all 0.15s;
        }

        .btn-primary {
            background: #3b82f6;
            color: white;
        }

        .btn-primary:hover {
            background: #2563eb;
        }

        .btn-block {
            width: 100%;
        }

        .form-actions {
            display: flex;
            gap: 0.75rem;
            margin-top: 1.5rem;
        }

        .form-actions .btn {
            flex: 1;
        }

        .success-icon {
            font-size: 4rem;
            text-align: center;
            margin-bottom: 1rem;
        }

        .success-title {
            font-size: 1.25rem;
            font-weight: 600;
            text-align: center;
            margin-bottom: 0.5rem;
        }

        .success-text {
            text-align: center;
            color: #64748b;
            margin-bottom: 1.5rem;
        }

        .success-actions {
            display: flex;
            flex-direction: column;
            gap: 0.75rem;
        }

        .success-actions a {
            display: block;
            text-align: center;
            padding: 0.75rem 1.5rem;
            border-radius: 0.5rem;
            font-weight: 500;
        }

        .success-actions .btn-primary {
            background: #3b82f6;
            color: white;
        }

        .success-actions .btn-secondary {
            background: #f1f5f9;
            color: #0f172a;
        }
    </style>
</head>
<body>
    <div class="install-container">
        <div class="install-header">
            <h1>🔗 网址导航</h1>
            <p>安装向导</p>
        </div>

        <div class="install-body">
            <div class="steps">
                <div class="step <?= $step >= 1 ? ($step > 1 ? 'completed' : 'active') : '' ?>">
                    <span class="step-number">1</span>
                    <span>环境检测</span>
                </div>
                <div class="step <?= $step >= 2 ? ($step > 2 ? 'completed' : 'active') : '' ?>">
                    <span class="step-number">2</span>
                    <span>数据库</span>
                </div>
                <div class="step <?= $step >= 3 ? ($step > 3 ? 'completed' : 'active') : '' ?>">
                    <span class="step-number">3</span>
                    <span>管理员</span>
                </div>
                <div class="step <?= $step >= 4 ? ($step > 4 ? 'completed' : 'active') : '' ?>">
                    <span class="step-number">4</span>
                    <span>完成</span>
                </div>
            </div>

            <?php if ($error): ?>
                <div class="alert alert-error"><?= htmlspecialchars($error) ?></div>
            <?php endif; ?>

            <?php if ($step === '1'): ?>
                <h2 class="section-title">环境检测</h2>

                <div class="check-list">
                    <?= checkRequirement('PHP 版本 >= 8.0', $phpVersion, '当前: ' . PHP_VERSION) ?>
                    <?= checkRequirement('PDO 扩展', $pdoExtension) ?>
                    <?= checkRequirement('PDO MySQL 扩展', $pdoMysql) ?>
                    <?= checkRequirement('GD 扩展', $gdExtension, '可选') ?>
                    <?= checkRequirement('CURL 扩展', $curlExtension, '可选') ?>
                    <?= checkRequirement('目录可写', $writeable) ?>
                </div>

                <?php if ($phpVersion && $pdoExtension && $pdoMysql && $writeable): ?>
                    <form method="POST">
                        <input type="hidden" name="step" value="2">
                        <button type="submit" class="btn btn-primary btn-block">下一步：配置数据库</button>
                    </form>
                <?php else: ?>
                    <div class="alert alert-error">请先解决以上环境问题后再继续安装</div>
                <?php endif; ?>

            <?php elseif ($step === '2'): ?>
                <h2 class="section-title">数据库配置</h2>

                <form method="POST">
                    <input type="hidden" name="step" value="2">

                    <div class="form-group">
                        <label for="db_host">数据库主机</label>
                        <input type="text" id="db_host" name="db_host" value="localhost" required>
                        <div class="hint">通常为 localhost</div>
                    </div>

                    <div class="form-group">
                        <label for="db_name">数据库名称</label>
                        <input type="text" id="db_name" name="db_name" placeholder="nav_system" required>
                        <div class="hint">数据库将自动创建（如果不存在）</div>
                    </div>

                    <div class="form-group">
                        <label for="db_user">数据库用户名</label>
                        <input type="text" id="db_user" name="db_user" placeholder="root" required>
                    </div>

                    <div class="form-group">
                        <label for="db_pass">数据库密码</label>
                        <input type="password" id="db_pass" name="db_pass" placeholder="留空表示无密码">
                    </div>

                    <div class="form-actions">
                        <a href="?step=1" class="btn btn-secondary">上一步</a>
                        <button type="submit" class="btn btn-primary">下一步</button>
                    </div>
                </form>

            <?php elseif ($step === '3'): ?>
                <h2 class="section-title">设置管理员账号</h2>

                <form method="POST">
                    <input type="hidden" name="step" value="4">

                    <div class="form-group">
                        <label for="admin_user">管理员用户名</label>
                        <input type="text" id="admin_user" name="admin_user" placeholder="admin" required>
                    </div>

                    <div class="form-group">
                        <label for="admin_email">管理员邮箱</label>
                        <input type="email" id="admin_email" name="admin_email" placeholder="admin@example.com" required>
                    </div>

                    <div class="form-group">
                        <label for="admin_pass">管理员密码</label>
                        <input type="password" id="admin_pass" name="admin_pass" placeholder="至少6位" required>
                    </div>

                    <div class="form-group">
                        <label for="admin_pass_confirm">确认密码</label>
                        <input type="password" id="admin_pass_confirm" name="admin_pass_confirm" required>
                    </div>

                    <div class="form-actions">
                        <a href="?step=1" class="btn btn-secondary">重新配置</a>
                        <button type="submit" class="btn btn-primary">完成安装</button>
                    </div>
                </form>

            <?php elseif ($step === '5' && $success): ?>
                <div class="success-icon">🎉</div>
                <h2 class="success-title">安装完成！</h2>
                <p class="success-text">网址导航系统已成功安装，您可以开始使用了。</p>

                <div class="success-actions">
                    <a href="/" class="btn-primary">访问首页</a>
                    <a href="/login.php" class="btn-secondary">登录后台</a>
                </div>

                <div class="alert alert-success" style="margin-top: 1.5rem;">
                    <strong>安全提示：</strong>建议删除 install.php 文件以提高安全性。
                </div>
            <?php endif; ?>
        </div>
    </div>
</body>
</html>
