<?php

require_once __DIR__ . '/header.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'] ?? '';
    $id = (int) ($_POST['id'] ?? 0);

    if ($id > 0) {
        if ($action === 'approve') {
            Link::approve($id);
            redirectWithMessage('/admin/pending.php', '链接已审核通过');
        } elseif ($action === 'reject') {
            Link::reject($id);
            redirectWithMessage('/admin/pending.php', '链接已拒绝', 'warning');
        } elseif ($action === 'delete') {
            Link::delete($id);
            redirectWithMessage('/admin/pending.php', '链接已删除');
        }
    }
}

$pendingLinks = Link::getByStatus('pending');

renderAdminHeader('待审核链接', 'pending');
?>

<div class="admin-header">
    <h1>待审核链接</h1>
</div>

<?php $flash = getFlashMessage(); ?>
<?php if ($flash): ?>
    <div class="alert alert-<?= h($flash['type']) ?>">
        <?= h($flash['text']) ?>
    </div>
<?php endif; ?>

<?php if (empty($pendingLinks)): ?>
    <div class="empty-state">
        <div class="empty-icon">✅</div>
        <h2>暂无待审核链接</h2>
        <p>所有提交的链接都已处理完毕</p>
    </div>
<?php else: ?>
    <div class="pending-list">
        <?php foreach ($pendingLinks as $link): ?>
            <div class="pending-card">
                <div class="pending-info">
                    <div class="pending-header">
                        <img src="<?= h($link['icon'] ?: getFaviconUrl($link['url'])) ?>" alt="" class="link-icon" onerror="this.src='/assets/images/default-icon.png'">
                        <div>
                            <h3><?= h($link['title']) ?></h3>
                            <a href="<?= h($link['url']) ?>" target="_blank" rel="noopener"><?= h($link['url']) ?></a>
                        </div>
                    </div>

                    <div class="pending-meta">
                        <span class="meta-item">
                            <strong>分类：</strong><?= h($link['category_name'] ?? '未分类') ?>
                        </span>
                        <span class="meta-item">
                            <strong>提交者：</strong><?= h($link['submitter_name'] ?? '管理员') ?>
                        </span>
                        <span class="meta-item">
                            <strong>提交时间：</strong><?= formatTime($link['created_at']) ?>
                        </span>
                    </div>

                    <?php if ($link['description']): ?>
                        <div class="pending-description">
                            <?= h($link['description']) ?>
                        </div>
                    <?php endif; ?>
                </div>

                <div class="pending-actions">
                    <form method="POST" style="display: inline;">
                        <input type="hidden" name="id" value="<?= $link['id'] ?>">
                        <button type="submit" name="action" value="approve" class="btn btn-primary btn-sm">通过</button>
                    </form>
                    <form method="POST" style="display: inline;">
                        <input type="hidden" name="id" value="<?= $link['id'] ?>">
                        <button type="submit" name="action" value="reject" class="btn btn-warning btn-sm">拒绝</button>
                    </form>
                    <form method="POST" style="display: inline;">
                        <input type="hidden" name="id" value="<?= $link['id'] ?>">
                        <button type="submit" name="action" value="delete" class="btn btn-danger btn-sm" onclick="return confirm('确定删除此链接？')">删除</button>
                    </form>
                </div>
            </div>
        <?php endforeach; ?>
    </div>
<?php endif; ?>

<?php renderAdminFooter(); ?>
