<?php

require_once __DIR__ . '/header.php';

$action = $_GET['action'] ?? 'list';
$id = isset($_GET['id']) ? (int) $_GET['id'] : 0;
$status = $_GET['status'] ?? null;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!verifyCsrfToken($_POST['csrf_token'] ?? '')) {
        redirectWithMessage('/admin/links.php', 'CSRF验证失败', 'error');
    }

    if ($action === 'create' || $action === 'edit') {
        $data = [
            'category_id' => (int) ($_POST['category_id'] ?? 0),
            'title' => trim($_POST['title'] ?? ''),
            'url' => trim($_POST['url'] ?? ''),
            'description' => trim($_POST['description'] ?? ''),
            'icon' => trim($_POST['icon'] ?? ''),
            'sort_order' => (int) ($_POST['sort_order'] ?? 0),
            'status' => $_POST['status'] ?? 'approved'
        ];

        if (empty($data['title']) || empty($data['url'])) {
            $error = '请填写标题和URL';
        } elseif (!validateUrl($data['url'])) {
            $error = '请输入有效的URL';
        } elseif ($data['category_id'] <= 0) {
            $error = '请选择分类';
        } else {
            if ($action === 'create') {
                Link::create($data);
                redirectWithMessage('/admin/links.php', '链接创建成功');
            } else {
                Link::update($id, $data);
                redirectWithMessage('/admin/links.php', '链接更新成功');
            }
        }
    }
}

if ($action === 'delete' && $id > 0) {
    if (Link::delete($id)) {
        redirectWithMessage('/admin/links.php', '链接删除成功');
    } else {
        redirectWithMessage('/admin/links.php', '链接删除失败', 'error');
    }
}

$categories = Category::all();
$links = Link::all($status);
$link = $id > 0 ? Link::find($id) : null;

renderAdminHeader('链接管理', 'links');
?>

<div class="admin-header">
    <h1>链接管理</h1>
    <a href="?action=create" class="btn btn-primary">添加链接</a>
</div>

<?php $flash = getFlashMessage(); ?>
<?php if ($flash): ?>
    <div class="alert alert-<?= h($flash['type']) ?>">
        <?= h($flash['text']) ?>
    </div>
<?php endif; ?>

<?php if ($action === 'create' || $action === 'edit'): ?>
    <div class="admin-card">
        <h2><?= $action === 'create' ? '添加链接' : '编辑链接' ?></h2>

        <?php if (isset($error)): ?>
            <div class="alert alert-error"><?= h($error) ?></div>
        <?php endif; ?>

        <form method="POST" class="form">
            <input type="hidden" name="csrf_token" value="<?= csrfToken() ?>">

            <div class="form-group">
                <label for="category_id">分类 *</label>
                <select id="category_id" name="category_id" required>
                    <option value="">选择分类</option>
                    <?php foreach ($categories as $cat): ?>
                        <option value="<?= $cat['id'] ?>" <?= ($link['category_id'] ?? '') == $cat['id'] ? 'selected' : '' ?>>
                            <?= h($cat['name']) ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>

            <div class="form-group">
                <label for="title">标题 *</label>
                <input type="text" id="title" name="title" value="<?= h($link['title'] ?? '') ?>" required>
            </div>

            <div class="form-group">
                <label for="url">URL *</label>
                <input type="url" id="url" name="url" value="<?= h($link['url'] ?? '') ?>" required>
            </div>

            <div class="form-group">
                <label for="description">描述</label>
                <textarea id="description" name="description" rows="3"><?= h($link['description'] ?? '') ?></textarea>
            </div>

            <div class="form-group">
                <label for="icon">图标URL（留空自动获取）</label>
                <input type="text" id="icon" name="icon" value="<?= h($link['icon'] ?? '') ?>">
            </div>

            <div class="form-group">
                <label for="sort_order">排序</label>
                <input type="number" id="sort_order" name="sort_order" value="<?= $link['sort_order'] ?? 0 ?>">
            </div>

            <div class="form-group">
                <label for="status">状态</label>
                <select id="status" name="status">
                    <option value="approved" <?= ($link['status'] ?? 'approved') === 'approved' ? 'selected' : '' ?>>已审核</option>
                    <option value="pending" <?= ($link['status'] ?? '') === 'pending' ? 'selected' : '' ?>>待审核</option>
                    <option value="rejected" <?= ($link['status'] ?? '') === 'rejected' ? 'selected' : '' ?>>已拒绝</option>
                </select>
            </div>

            <div class="form-actions">
                <button type="submit" class="btn btn-primary">保存</button>
                <a href="?action=list" class="btn btn-secondary">取消</a>
            </div>
        </form>
    </div>

<?php else: ?>
    <div class="filter-bar">
        <a href="?status=" class="btn btn-sm <?= $status === null ? 'btn-primary' : 'btn-secondary' ?>">全部</a>
        <a href="?status=approved" class="btn btn-sm <?= $status === 'approved' ? 'btn-primary' : 'btn-secondary' ?>">已审核</a>
        <a href="?status=pending" class="btn btn-sm <?= $status === 'pending' ? 'btn-primary' : 'btn-secondary' ?>">待审核</a>
        <a href="?status=rejected" class="btn btn-sm <?= $status === 'rejected' ? 'btn-primary' : 'btn-secondary' ?>">已拒绝</a>
    </div>

    <div class="table-responsive">
        <table class="table">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>标题</th>
                    <th>分类</th>
                    <th>点击</th>
                    <th>状态</th>
                    <th>操作</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($links as $l): ?>
                    <tr>
                        <td><?= $l['id'] ?></td>
                        <td>
                            <div class="link-title">
                                <img src="<?= h($l['icon'] ?: getFaviconUrl($l['url'])) ?>" alt="" class="link-icon" onerror="this.src='/assets/images/default-icon.png'">
                                <div>
                                    <div class="link-name"><?= h($l['title']) ?></div>
                                    <div class="link-url"><?= h(truncate($l['url'], 50)) ?></div>
                                </div>
                            </div>
                        </td>
                        <td><?= h($l['category_name'] ?? '-') ?></td>
                        <td><?= $l['click_count'] ?></td>
                        <td>
                            <span class="status-badge <?= $l['status'] ?>">
                                <?= $l['status'] === 'approved' ? '已审核' : ($l['status'] === 'pending' ? '待审核' : '已拒绝') ?>
                            </span>
                        </td>
                        <td class="actions">
                            <a href="?action=edit&id=<?= $l['id'] ?>" class="btn btn-sm">编辑</a>
                            <a href="?action=delete&id=<?= $l['id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('确定删除此链接？')">删除</a>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
<?php endif; ?>

<?php renderAdminFooter(); ?>
