<?php

require_once __DIR__ . '/header.php';

$linkStats = Link::getStats();
$userStats = User::getStats();
$categories = Category::getWithLinkCount();

renderAdminHeader('仪表盘', 'dashboard');
?>

<div class="admin-header">
    <h1>仪表盘</h1>
</div>

<?php $flash = getFlashMessage(); ?>
<?php if ($flash): ?>
    <div class="alert alert-<?= h($flash['type']) ?>">
        <?= h($flash['text']) ?>
    </div>
<?php endif; ?>

<div class="stats-grid">
    <div class="stat-card">
        <div class="stat-icon">🔗</div>
        <div class="stat-content">
            <div class="stat-value"><?= $linkStats['total'] ?? 0 ?></div>
            <div class="stat-label">总链接数</div>
        </div>
    </div>
    <div class="stat-card">
        <div class="stat-icon">✅</div>
        <div class="stat-content">
            <div class="stat-value"><?= $linkStats['approved'] ?? 0 ?></div>
            <div class="stat-label">已审核</div>
        </div>
    </div>
    <div class="stat-card">
        <div class="stat-icon">⏳</div>
        <div class="stat-content">
            <div class="stat-value"><?= $linkStats['pending'] ?? 0 ?></div>
            <div class="stat-label">待审核</div>
        </div>
    </div>
    <div class="stat-card">
        <div class="stat-icon">👆</div>
        <div class="stat-content">
            <div class="stat-value"><?= $linkStats['total_clicks'] ?? 0 ?></div>
            <div class="stat-label">总点击</div>
        </div>
    </div>
</div>

<div class="admin-section">
    <h2>分类概览</h2>
    <div class="table-responsive">
        <table class="table">
            <thead>
                <tr>
                    <th>分类名称</th>
                    <th>链接数量</th>
                    <th>状态</th>
                    <th>排序</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($categories as $category): ?>
                    <tr>
                        <td><?= h($category['name']) ?></td>
                        <td><?= $category['link_count'] ?></td>
                        <td>
                            <span class="status-badge <?= $category['is_active'] ? 'active' : 'inactive' ?>">
                                <?= $category['is_active'] ? '启用' : '禁用' ?>
                            </span>
                        </td>
                        <td><?= $category['sort_order'] ?></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<?php renderAdminFooter(); ?>
