<?php

require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../models/Category.php';
require_once __DIR__ . '/../models/Link.php';
require_once __DIR__ . '/../models/User.php';

Auth::requireAdmin();

$currentUser = Auth::user();
$pendingCount = Link::getPendingCount();

function renderAdminHeader(string $title, string $currentPage = '') {
    global $currentUser, $pendingCount;
?>
<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= h($title) ?> - 管理后台 - <?= SITE_NAME ?></title>
    <link rel="stylesheet" href="https://img.penlife.cn/font/OPPO%20Sans%204/result.css">
    <link rel="stylesheet" href="/assets/css/style.css">
</head>
<body class="admin-page">
    <nav class="admin-nav">
        <div class="admin-nav-brand">
            <a href="/"><?= SITE_NAME ?></a>
        </div>
        <div class="admin-nav-menu">
            <a href="/admin/" class="<?= $currentPage === 'dashboard' ? 'active' : '' ?>">仪表盘</a>
            <a href="/admin/categories.php" class="<?= $currentPage === 'categories' ? 'active' : '' ?>">分类管理</a>
            <a href="/admin/links.php" class="<?= $currentPage === 'links' ? 'active' : '' ?>">链接管理</a>
            <a href="/admin/pending.php" class="<?= $currentPage === 'pending' ? 'active' : '' ?>">
                待审核
                <?php if ($pendingCount > 0): ?>
                    <span class="badge"><?= $pendingCount ?></span>
                <?php endif; ?>
            </a>
        </div>
        <div class="admin-nav-user">
            <span><?= h($currentUser['username']) ?></span>
            <a href="/logout.php" class="btn btn-sm">退出</a>
        </div>
    </nav>

    <main class="admin-main">
<?php
}

function renderAdminFooter() {
?>
    </main>
</body>
</html>
<?php
}
