<?php

require_once __DIR__ . '/header.php';

$action = $_GET['action'] ?? 'list';
$id = isset($_GET['id']) ? (int) $_GET['id'] : 0;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!verifyCsrfToken($_POST['csrf_token'] ?? '')) {
        redirectWithMessage('/admin/categories.php', 'CSRF验证失败', 'error');
    }

    if ($action === 'create' || $action === 'edit') {
        $data = [
            'name' => trim($_POST['name'] ?? ''),
            'slug' => trim($_POST['slug'] ?? ''),
            'description' => trim($_POST['description'] ?? ''),
            'icon' => trim($_POST['icon'] ?? ''),
            'sort_order' => (int) ($_POST['sort_order'] ?? 0),
            'is_active' => isset($_POST['is_active']) ? 1 : 0
        ];

        if (empty($data['name'])) {
            $error = '请输入分类名称';
        } else {
            if ($action === 'create') {
                Category::create($data);
                redirectWithMessage('/admin/categories.php', '分类创建成功');
            } else {
                Category::update($id, $data);
                redirectWithMessage('/admin/categories.php', '分类更新成功');
            }
        }
    }
}

if ($action === 'delete' && $id > 0) {
    if (Category::delete($id)) {
        redirectWithMessage('/admin/categories.php', '分类删除成功');
    } else {
        redirectWithMessage('/admin/categories.php', '分类删除失败', 'error');
    }
}

if ($action === 'toggle' && $id > 0) {
    Category::toggleActive($id);
    redirectWithMessage('/admin/categories.php', '状态更新成功');
}

$categories = Category::getWithLinkCount();
$category = $id > 0 ? Category::find($id) : null;

renderAdminHeader('分类管理', 'categories');
?>

<div class="admin-header">
    <h1>分类管理</h1>
    <a href="?action=create" class="btn btn-primary">添加分类</a>
</div>

<?php $flash = getFlashMessage(); ?>
<?php if ($flash): ?>
    <div class="alert alert-<?= h($flash['type']) ?>">
        <?= h($flash['text']) ?>
    </div>
<?php endif; ?>

<?php if ($action === 'create' || $action === 'edit'): ?>
    <div class="admin-card">
        <h2><?= $action === 'create' ? '添加分类' : '编辑分类' ?></h2>

        <?php if (isset($error)): ?>
            <div class="alert alert-error"><?= h($error) ?></div>
        <?php endif; ?>

        <form method="POST" class="form">
            <input type="hidden" name="csrf_token" value="<?= csrfToken() ?>">

            <div class="form-group">
                <label for="name">分类名称 *</label>
                <input type="text" id="name" name="name" value="<?= h($category['name'] ?? '') ?>" required>
            </div>

            <div class="form-group">
                <label for="slug">别名（留空自动生成）</label>
                <input type="text" id="slug" name="slug" value="<?= h($category['slug'] ?? '') ?>">
            </div>

            <div class="form-group">
                <label for="description">描述</label>
                <textarea id="description" name="description" rows="3"><?= h($category['description'] ?? '') ?></textarea>
            </div>

            <div class="form-group">
                <label for="icon">图标（图标名称或emoji）</label>
                <input type="text" id="icon" name="icon" value="<?= h($category['icon'] ?? '') ?>">
            </div>

            <div class="form-group">
                <label for="sort_order">排序</label>
                <input type="number" id="sort_order" name="sort_order" value="<?= $category['sort_order'] ?? 0 ?>">
            </div>

            <div class="form-group">
                <label class="checkbox-label">
                    <input type="checkbox" name="is_active" <?= ($category['is_active'] ?? 1) ? 'checked' : '' ?>>
                    启用此分类
                </label>
            </div>

            <div class="form-actions">
                <button type="submit" class="btn btn-primary">保存</button>
                <a href="?action=list" class="btn btn-secondary">取消</a>
            </div>
        </form>
    </div>

<?php else: ?>
    <div class="table-responsive">
        <table class="table">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>图标</th>
                    <th>名称</th>
                    <th>别名</th>
                    <th>链接数</th>
                    <th>排序</th>
                    <th>状态</th>
                    <th>操作</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($categories as $cat): ?>
                    <tr>
                        <td><?= $cat['id'] ?></td>
                        <td><?= h($cat['icon'] ?? '📁') ?></td>
                        <td><?= h($cat['name']) ?></td>
                        <td><code><?= h($cat['slug']) ?></code></td>
                        <td><?= $cat['link_count'] ?></td>
                        <td><?= $cat['sort_order'] ?></td>
                        <td>
                            <a href="?action=toggle&id=<?= $cat['id'] ?>" class="status-badge <?= $cat['is_active'] ? 'active' : 'inactive' ?>">
                                <?= $cat['is_active'] ? '启用' : '禁用' ?>
                            </a>
                        </td>
                        <td class="actions">
                            <a href="?action=edit&id=<?= $cat['id'] ?>" class="btn btn-sm">编辑</a>
                            <a href="?action=delete&id=<?= $cat['id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('确定删除此分类？相关链接也会被删除。')">删除</a>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
<?php endif; ?>

<?php renderAdminFooter(); ?>
